import { createSlice, PayloadAction } from "@reduxjs/toolkit";

type InventoryState = {
  selectedPackCover: string | null;
};

const initialState: InventoryState = {
  selectedPackCover: null,
};

const inventorySlice = createSlice({
  name: "inventory",
  initialState,
  reducers: {
    setSelectedPackCover: (state, action: PayloadAction<string | null>) => {
      state.selectedPackCover = action.payload;
    },
    clearSelectedPackCover: (state) => {
      state.selectedPackCover = null;
    },
  },
});

export const { setSelectedPackCover, clearSelectedPackCover } =
  inventorySlice.actions;

export default inventorySlice.reducer;
