import { createSlice } from "@reduxjs/toolkit";

type UIState = {
  chatOpen: boolean;
};

const initialState: UIState = {
  chatOpen: false,
};

const uiSlice = createSlice({
  name: "ui",
  initialState,
  reducers: {
    toggleChat(state) {
      state.chatOpen = !state.chatOpen;
    },
    setChatOpen(state, action) {
      state.chatOpen = action.payload;
    },
  },
});

export const { toggleChat, setChatOpen } = uiSlice.actions;
export default uiSlice.reducer;
