// store/authSlice.ts
import { User } from "@/constants/types";
import { createSlice, PayloadAction } from "@reduxjs/toolkit";

// export interface User {
//   id: string;
//   name: string;
//   email: string;
// }
// export interface User {
//   id?: string;        // optional, agar kabhi use hota ho
//   userId: string;     // ✅ tum use kar rahe ho
//   name: string;
//   email?: string;     // optional
//   image?: string;     // ✅ add (for profile image)
//   token: string;      // ✅ add (you use user.token)
//    balance?: number;
//   level?: { lavel: number; xp: any; next: number };
// }



interface AuthState {
  user: User | null;
  status: "idle" | "loading" | "authenticated" | "unauthenticated";
}

const initialState: AuthState = {
  user: null,
  status: "idle",
};
export type { User };
const authSlice = createSlice({
  name: "auth",
  initialState,
  reducers: {
    setUser(state, action: PayloadAction<User | null>) {
      state.user = action.payload;
      state.status = action.payload ? "authenticated" : "unauthenticated";
    },
     // ✅ minimal "session update" action
    updateUser(state, action: PayloadAction<Partial<User>>) {
      if (!state.user) return;
      state.user = { ...state.user, ...action.payload };
    },
    logout(state) {
      state.user = null;
      state.status = "unauthenticated";
    },
  },
});

export const { setUser, logout,updateUser} = authSlice.actions;
export default authSlice.reducer;
