import { BASE_URL, parseJsonOrLogout } from "@/constants";

export async function getRollHistory(user_id: string, token: string) {
  try {
    const res = await fetch(`${BASE_URL}/api/roll-history`, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${token}`,
      },
      body: JSON.stringify({ user_id }),
    });

    return parseJsonOrLogout(res);
  } catch (e) {
    throw e;
  }
}
