export const API_BASE_URL = "https://backend.openthatcard.com/";
export const API_URL = "https://backend.openthatcard.com/api/";
export const API_URL_OTP = "https://backend.openthatpack.com/api/";


export const sendRequest = (option, token, callback) => {
    let url  = option.url;
    let method = option?.method || "POST"; 
    let headers = {
        "Content-Type": "application/json",
        "Accept": "*/*",
        "User-Agent": "Thunder Client (https://www.thunderclient.com)",
        Authorization: `Bearer ${token}`
    }
    let h = option?.header || [];
    h.forEach(function(i){
        headers[i.name] = i.value;
    });
    let body = option?.body || {};
    let opt = null;
    if (method === "POST"){
        opt = {
                method: method,
                headers: headers,
                body: JSON.stringify(body),
            };    
    }else{
        opt = {
                method: method,
                headers: headers,
            };
    }
    const handle = async () => {
        try{
            const response = await fetch(url, opt);
            if (response.ok) {
                const responseData = await response.json();
                callback(responseData);
            }else{
                callback({resp:"error", message:"Something is wrong."});    
            }
        }catch(error){
            callback({resp:"error", message:error});
        }
    }
    handle();
}

export function formatNumber(num) {
  if (num >= 1_000_000) {
    return (num / 1_000_000).toFixed(num % 1_000_000 === 0 ? 0 : 1) + "M";
  } else if (num >= 1_000) {
    return (num / 1_000).toFixed(num % 1000 === 0 ? 0 : 1) + "K";
  } else {
    return num.toString();
  }
}
