"use client";

import Image from "next/image";

type ChildTab = "all" | "magic" | "pokemon" | "lorcana" | "slab";

type Props = {
  search: string;
  setSearch: (v: string) => void;
  childTab: ChildTab;
  setChildTab: (t: ChildTab) => void;
  bulkPrice: string | number;
  //   onBack: () => void;
};

export default function WithdrawHeader({
  search,
  setSearch,
  childTab,
  setChildTab,
  bulkPrice,
}: //   onBack,
Props) {
  return (
    <div className=" z-10">
      <div className="container mx-auto my-2">
        <div className="flex items-center flex-col md:flex-row justify-between gap-3">
          <div className="">
            <div className="flex mb-3 items-center gap-3">
              <div className="flex  items-center gap-4">
                <button
                  //   onClick={onBack}
                  className="cursor-pointer text-xs md:text-sm p-2 px-4 font-extrabold text-white bg-[var(--color-gray)] hover:text-white italic font-sofia transition"
                >
                  &lt; BACK
                </button>
                <h1 className="text-sm md:text-2xl 2xl:text-3xl font-extrabold italic ">
                  WITHDRAW
                </h1>
              </div>

              <input
                type="text"
                placeholder="SEARCH ITEMS"
                value={search}
                onChange={(e) => setSearch(e.target.value)}
                className="text-[#DBFAFF] py-1 md:py-2  text-base md:text-lg 2xl:text-2xl font-sofia border border-[#29313D] px-5 md:min-w-[250px] outline-none focus:outline-none focus:ring-0"
              />
            </div>

            <div className="flex flex-wrap gap-2 2xl:gap-4">
              <button
                onClick={() => setChildTab("all")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "all"
                    ? " text-white !border-[var(--color-blue)]"
                    : "text-[var(--color-slate)]  border-transparent cursor-pointer hover:opacity-100 hover:bg-[var(--color-gray)] opacity-60"
                }`}
              >
                ALL BRANDS
              </button>

              <button
                onClick={() => setChildTab("magic")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "magic"
                    ? " text-white !border-[var(--color-blue)]"
                    : "text-[var(--color-slate)]  border-transparent cursor-pointer hover:opacity-100 hover:bg-[var(--color-gray)] opacity-60"
                }`}
              >
                <span className="flex items-center gap-2">
                  <Image
                    width={117}
                    height={37}
                    src="/images/inventory/magic.svg"
                    alt="magic"
                    className="w-12 md:w-full"
                  />
                </span>
              </button>

              <button
                onClick={() => setChildTab("pokemon")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "pokemon"
                    ? " text-white !border-[var(--color-blue)]"
                    : "text-[var(--color-slate)]  border-transparent cursor-pointer hover:opacity-100 hover:bg-[var(--color-gray)] opacity-60"
                }`}
              >
                <Image
                  width={117}
                  height={37}
                  src="/images/inventory/pokemon.svg"
                  alt="pokemon"
                  className="w-12 md:w-full"
                />
              </button>

              <button
                onClick={() => setChildTab("lorcana")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "lorcana"
                    ? " text-white !border-[var(--color-blue)]"
                    : "text-[var(--color-slate)]  border-transparent cursor-pointer hover:opacity-100 hover:bg-[var(--color-gray)] opacity-60"
                }`}
              >
                <Image
                  width={117}
                  height={37}
                  src="/images/inventory/lorcana.svg"
                  alt="lorcana"
                  className="w-12 md:w-full"
                />
              </button>
               <button
                onClick={() => setChildTab("slab")}
                className={`px-4 md:px-6 py-2 md:py-3 font-extrabold transition-all text-xs 2xl:text-lg bg-[var(--color-naviBlue)] border-b-[3px] font-sofia border-transparent duration-500 md:text-base ${
                  childTab === "slab"
                    ? " text-white !border-[var(--color-blue)]"
                    : "text-[var(--color-slate)]  border-transparent cursor-pointer hover:opacity-100 hover:bg-[var(--color-gray)] opacity-60"
                }`}
              >
               Slab
              </button>
            </div>
          </div>

          <div className="font-sofia text-center font-bold text-base md:text-xl mt-4 space-y-2">
            <div className="text-[var(--color-slate)]">
              ADD <span className="text-[var(--color-blue)]">$100.00</span>{" "}
              WORTH OF CARDS TO GET FREE SHIPPING
            </div>

            <div className="flex items-center justify-center gap-2">
              <span>Bulk card surcharge:</span>
              <span className="px-3 py-1 rounded-full bg-red-500/20 text-red-400 text-sm md:text-base">
                ${bulkPrice}
              </span>
            </div>

            <p className="text-sm md:text-base text-[var(--color-slate)] font-medium">
              Marketplace cards do not count towards free shipping
            </p>
          </div>
        </div>
      </div>
    </div>
  );
}
