"use client";

import { useRouter } from "next/navigation";
import { useEffect } from "react";

type withdrawActionBarProps = {
  selectedCount: number;
  allOnScreenCount: number;
  totalValue: string;
  onSelectAll: () => void;
  isLockedAll: boolean;
  bulkCount: number;
  bulkPrice: string;
  cards: string; // <-- ADD THIS
  cardImage: string[];
  open: boolean;
  onClose: () => void;
  onOpen: () => void;
  toggleSelect: (id: any) => void;
  selectedCards: { id: string; image: string }[];
};

export default function WithdrawActionBar({
  selectedCount,
  allOnScreenCount,
  totalValue,
  onSelectAll,
  bulkCount,
  bulkPrice,
  cards,
  cardImage,
  open,
  onClose, // ✅ MUST ADD THIS
  toggleSelect,
  selectedCards,
  onOpen,
}: withdrawActionBarProps) {
  if (selectedCount === 0) return null;

  const router = useRouter();
  const allSelected = selectedCount === allOnScreenCount;

  const onSell = () => {
    // Save to localStorage
    localStorage.setItem("selectedCount", String(selectedCount));
    localStorage.setItem("totalValue", String(totalValue));
    localStorage.setItem("bulkCount", String(bulkCount));
    localStorage.setItem("bulkPrice", String(bulkPrice));
    localStorage.setItem("cards", cards ?? "");

    // Build URL params
    // const params = new URLSearchParams({
    //   selectedCount: String(selectedCount),
    //   totalValue,
    //   bulkCount: String(bulkCount),
    //   bulkPrice: String(bulkPrice),
    //   cards: cards ?? "",
    // });

    router.push(`/withdraw/shipping`);
    // router.push(`/withdraw/shipping?${params.toString()}`);
  };

  return (
    <div
      className={`
          fixed top-0 right-0 h-screen w-40 md:w-90 2xl:w-125
          bg-(--color-naviBlue) border-l border-[#151C29]
          shadow-xl z-9999
          transform transition-transform duration-500 ease-in-out
          ${open ? "translate-x-0" : "translate-x-full"}
        `}
    >
      {!open && (
        <button
          onClick={onOpen}
          className="
            absolute
            -left-6
            bottom-16
            h-6 w-6
            z-50
            px-1
            bg-white/10 hover:bg-white/20
            flex items-center justify-center
          "
        >
          <img
            src="/images/chatbot/left.png"
            alt=""
            className={`transition-transform ${open ? "rotate-180" : ""}`}
          />
        </button>
      )}
      <div className="px-4 pt-4 pb-2">
        <h2 className="text-xs md:text-sm font-sofia font-extrabold ">
          WITHDRAW CARDS
        </h2>
      </div>

      <button
        className="absolute top-3 right-3 text-white text-lg font-bold"
        onClick={onClose}
      >
        ✕
      </button>
      {/* Selected card images */}
      {selectedCards.length > 0 && (
        <div className="px-4 mt-4  max-h-[70vh] 2xl:max-h-[82vh] nice-scrollbar overflow-y-auto">
          <div className="grid grid-cols-3 md:grid-cols-5 2xl:grid-cols-5 gap-2">
            {selectedCards.map((src, index) => (
              <div
                key={index}
                onClick={(e) => {
                  console.log("clicked");
                  e.stopPropagation();
                  toggleSelect(src?.id);
                }}
                className="w-full border cursor-pointer border-(--color-blue) p-1 aspect-3/4 rounded-md"
              >
                <img
                  src={src.image.replace("cardsimages", "cards/images")}
                  alt=""
                  className="w-full h-full object-cover rounded-xs"
                />
              </div>
            ))}
          </div>
        </div>
      )}

      <div className="w-full border py-3 !font-onest !bg-[#161E2A] border-[#29313D] absolute bottom-0">
        <div className="flex md:px-4 flex-col md:flex-row items-center gap-2">
          <div className="flex-1 gap-2 flex-wrap text-xs md:text-sm 2xl:text-base !font-onest">
            {/* Left */}
            <div className="flex items-center justify-between gap-2 ">
              <div className="text-[10px] font-bold"> TOTAL ITEMS</div>
              <div className="pl-0 px-3 text-xs md:text-xl font-extrabold">
                {selectedCount}
              </div>

              <button
                onClick={onSelectAll}
                className="px-2 leading-3.5 border border-transparent hover:border-white duration-300 hover:text-white transition-all py-1 2xl:py-2 bg-white text-[var(--color-blue)] hover:bg-[#1f2433] font-medium"
              >
                {allSelected ? "DESELECT ALL" : "SELECT ALL"}
              </button>
            </div>

            {/* Right */}
            <div className="flex items-center flex-wrap justify-between gap-2">
              <div className="text-[10px] font-bold">TOTAL VALUE</div>
              <div className="text-(--color-blue) font-extrabold text-sm ">
                ${totalValue}
              </div>
            </div>
          </div>
          <button
            onClick={onSell}
            className="px-4 py-2 flex-1 bg-(--color-blue) hover:bg-[#5d5cff] text-xs md:text-sm 2xl:text-base"
          >
            CONTINUE TO SHIPPING
          </button>
        </div>
      </div>
    </div>
  );
}
