import React from "react";
import Image from "next/image";
import { PackData } from "@/app/types/packs";
import { useSelector } from "react-redux";
import { User } from "@/constants/types";

interface PackCardProps {
  pack: PackData;
  isSelected: boolean;
  onClick: () => void;
  getPlaceholderByTab: (activeTab: any) => string;
  activeTab: any;
}

export const PackCard: React.FC<PackCardProps> = ({
  pack,
  isSelected,
  onClick,
  getPlaceholderByTab,
  activeTab,
}) => {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  return (
    <button
      onClick={onClick}
      className={` relative bg-[var(--color-naviBlue)] relative min-h-[202px] px-6 group cursor-pointer transition-all duration-300 ${
        isSelected
          ? "border-[2.64px] box-shadow-custom-inset border-[var(--color-blue)]"
          : "border-[2.64px] border-transparent"
      }`}
    >
      <div className="w-20 h-36 my-2=5">
        <Image
          width={300}
          height={317}
          src={
            pack?.packImage?.trim()
              ? pack.packImage.replace("cardsimages", "cards/images")
              : getPlaceholderByTab(activeTab)
          }
          alt={pack.name}
          className={`object-contain   ${
            !isSelected && "group-hover:translate-y-1 group-hover:rotate-3"
          }  duration-500`}
        />
      </div>

      <div className="mt-2 text-center">
        {!isSelected && (
          <div className="relative h-6 md:h-8 2xl:h-9 pt-2 flex items-center justify-center">
            {/* Name (shown on hover) */}
            <h1
              className="
        text-white 
        text-sm md:text-lg 2xl:text-xl 
        font-sofia
        opacity-0 
        group-hover:opacity-100 
        transition-opacity 
        duration-1000
        absolute inset-0 
        flex items-center justify-center leading-4.5
      "
            >
              {pack.name}
            </h1>

            {/* Price (hidden on hover) */}
            <p
              className={`
    text-[var(--color-blue)]
    font-bold
    text-sm md:text-lg 2xl:text-xl
    font-sofia
    transform
    transition-all flex items-center gap-2
    duration-400
    ${
      isSelected
        ? "hidden"
        : "opacity-100 translate-y-0 group-hover:opacity-0 group-hover:translate-y-8"
    }
  `}
            >
              {!user ? (
                <img src="/images/header/win.svg" alt="" className="h-5 w-5" />
              ) : (
                <>
                  {user?.activeMode === "coins" ? (
                    <img
                      src="/images/header/win.svg"
                      alt=""
                      className="h-5 w-5"
                    />
                  ) : (
                    <img
                      src="/images/header/star.svg"
                      alt=""
                      className="h-5 w-5"
                    />
                  )}
                </>
              )}
              {pack.price}
            </p>
          </div>
        )}
      </div>
    </button>
  );
};
