import Image from "next/image";

interface Card {
  id: number;
  name: string;
  image: string;
}

interface CardDisplayProps {
  cards: Card[];
  limit?: number; // optional: default 6
  chatOpen?: boolean;
}

export const CardDisplay: React.FC<CardDisplayProps> = ({
  cards,
  limit = 6,
  chatOpen,
}) => {
  const visible = cards.slice(0, limit);
  console.log("cards", cards);
  return (
   <div
    className={`grid items-center gap-3 justify-items-center ${
      chatOpen ? "grid-cols-4 md:grid-cols-6" : "grid-cols-4 md:grid-cols-8"
    }`}
  >
      {visible.map((card) => (
        <div key={card.id} className="overflow-hidden w-16 h-22 transition-all">
          <Image
            width={117}
            height={176}
            src={card.image.replace("cardsimages", "cards/images")} // already full URL from API mapping
            alt={card.name}
            className="w-full h-full object-contain img-border-radius"
          />
        </div>
      ))}
    </div>
  );
};
