type SuccessModalProps = {
  open: boolean;
  onClose: () => void;
};

export const SuccessModal: React.FC<SuccessModalProps> = ({
  open,
  onClose,
}) => {
  if (!open) return null;

  return (
    <div
      className="
        fixed inset-0 z-[99999]
        flex items-center justify-center
        bg-black/70
      "
    >
      <div
        className="
          bg-[#161E2A] rounded-xl
          px-8 py-6
          max-w-lg w-[90%]
          text-center
          border border-white/10
        "
      >
        <div className="flex justify-center">
          <img src="/images/shipping/img.svg" alt="" />
        </div>
        <p className="text-white font-sofia mt-7 font-extrabold italic text-sm md:text-xl 2xl:text-2xl tracking-wide uppercase">
          WITHDRAW ORDER COMPLETED
        </p>
        <p className="text-white font-sofia mt-7 font-extrabold text-sm md:text-base font-onest tracking-wide uppercase">
          Your withdrawal order is being processed. Check your email
          and notifications for more updates
        </p>
        <div className="flex justify-center">
          <button
            type="button"
            onClick={onClose}
            className="mt-7 py-2
 w-[250px]          
           border border-white
            text-white font-sofia font-bold font-onest
            text-sm md:text-base
            hover:bg-white hover:text-black
            transition
          "
          >
            View in Profile
          </button>
        </div>
      </div>
    </div>
  );
};
