import PlayingForBar from "./PlayingForBar";

type RoundControlsProps = {
  progressPct: number;
  rollPhase: "countdown" | "break";
  winnerTier: string | null;
  playersByTier: Record<string, any[]>;
};

export default function RoundControls({
  progressPct,
  rollPhase,
  winnerTier,
  playersByTier,
}: RoundControlsProps) {
  return (
    <div className="space-y-3 text-center">
      <p className="text-base mt-3 font-semibold md:text-2xl 2xl:text-4xl italic font-sofia text-[#FF348D] uppercase">
        {rollPhase === "countdown" && "Next round starts in"}
      </p>

      <div className="w-full bg-[#131519] h-3  overflow-hidden rounded">
        <div
          className="h-full bg-[#4D4CFE]"
          style={{ width: `${progressPct}%` }}
        />
      </div>

      {winnerTier && (
        <PlayingForBar
          winnerTier={winnerTier}
          players={playersByTier[winnerTier] ?? []}
        />
      )}
    </div>
  );
}
