// "use client";

// type RewardModalProps = {
//   isOpen: boolean;
//   onClose: () => void;
// };

// export const RewardModal: React.FC<RewardModalProps> = ({ isOpen, onClose }) => {
//   if (!isOpen) return null;

//   return (
//     <div className="fixed inset-0 z-50 flex items-center justify-center">
//       {/* backdrop */}
//       <div
//         className="absolute inset-0 bg-black/70"
//         onClick={onClose}
//       />

//       {/* modal */}
//       <div className="relative z-10 w-[90%] max-w-md rounded-md bg-[#161E2A] border border-[#29313D] p-6 text-white">
//         <h2 className="text-lg md:text-xl font-bold mb-4">Reward claimed!</h2>
//         <p className="text-sm md:text-base text-slate-300 mb-6">
//           Your reward has been added to your account.
//         </p>

//         <button
//           onClick={onClose}
//           className="bg-[#4D4CFE] w-full font-onest font-semibold text-xs md:text-sm 2xl:text-base py-2 px-4"
//         >
//           CLOSE
//         </button>
//       </div>
//     </div>
//   );
// };

// components/RewardTiersModal.tsx
"use client";

import { User } from "@/constants/types";
import { useSelector } from "react-redux";

type RewardTier = {
  level: number;
  reward: string;
};

const rewardTiers: RewardTier[] = [
  { level: 21, reward: "4%" },
  { level: 22, reward: "5%" },
  { level: 23, reward: "6%" },
  { level: 24, reward: "7%" },
  { level: 25, reward: "12%" },
  { level: 26, reward: "15%" },
  { level: 27, reward: "20%" },
  { level: 28, reward: "25%" },
  { level: 29, reward: "30%" },
  { level: 30, reward: "8%" },
  { level: 31, reward: "40%" },
  { level: 32, reward: "60%" },
  { level: 33, reward: "80%" },
];

type RewardTiersModalProps = {
  isOpen: boolean;
  onClose: () => void;
};

export const RewardTiersModal: React.FC<RewardTiersModalProps> = ({
  isOpen,
  onClose,
}) => {
  const user = useSelector((state: any) => state.auth.user) as User | null;

  if (!isOpen) return null;

  return (
    <div className="fixed inset-0 z-[9999] flex items-center justify-center">
      {/* backdrop */}
      <div
        className="absolute inset-0 bg-black/70 backdrop-blur-sm"
        onClick={onClose}
      />

      {/* main panel */}
      <div className="relative z-10 w-[95%] max-w-3xl bg-[#161E2A] border border-[#29313D] text-white">
        {/* header */}
        <div className="flex cursor-pointer items-center gap-4 px-6 py-5 border-b border-[#29313D]">
          <button
            onClick={onClose}
            className="bg-[#29313D] font-sofia  text-xs md:text-sm 2xl:text-base px-3 py-2 font-bold uppercase tracking-wide"
          >
            &lt; Back
          </button>
          <h2 className="text-base md:text-xl font-extrabold italic tracking-tight uppercase">
            Reward Tiers
          </h2>
          <h2 className="text-base md:text-xl font-extrabold italic tracking-tight uppercase">
            User Level: {user?.level.lavel}
          </h2>
        </div>

        {/* table */}
        <div className="px-6 py-6 max-h-[70vh] overflow-y-auto scrollbar-hide">
          {/* header row */}
          <div className="flex justify-between text-xs md:text-lg 2xl:text-xl font-sofia mb-4">
            <span>Level</span>
            <span>Reward %</span>
          </div>

          <div className="space-y-2 font-onest ">
            {rewardTiers.map((row, ind) => (
              <div
                key={row.level}
                className={`flex items-center justify-between ${
                  ind % 2 === 0 && "bg-[#121924]"
                } px-4 py-3 text-xs md:text-sm`}
              >
                <span className="uppercase">Level {row.level}</span>
                <span>{row.reward}</span>
              </div>
            ))}
          </div>

          {/* bottom CTA if you still want it inside the modal */}
          {/* <button
            onClick={onClose}
            className="bg-[#4D4CFE] w-fit mt-8 font-onest font-semibold text-xs md:text-sm 2xl:text-base py-2 px-10"
          >
            Claim Reward
          </button> */}
        </div>
      </div>
    </div>
  );
};
