interface StatCardProps {
  label: string;
  primaryValue: string;
}

export const StatCard: React.FC<StatCardProps> = ({ label, primaryValue }) => {
  return (
    <div className="flex flex-col justify-between  border border-[var(--color-gray)] px-2 py-4 items-center ">
      <p
        className={`text-sm font-normal  font-onest text-center uppercase tracking-wide`}
      >
        {label}
      </p>
      <p
        className={`text-2xl font-extrabold  font-sofia ${
          primaryValue === "MEWTWO EX" ? "text-[var(--color-lightBlye)]" : ""
        }`}
      >
        {primaryValue}
      </p>
    </div>
  );
};
