import { useState } from "react";
import Balance from "./Balance";
import Shipping from "./Shipping";
import Packs from "./Packs";
import GamesRecord from "./GamesRecord";
import SportsbookRecord from "./SportsbookRecord";

type HistorySubTab =
  | "balance"
  | "shipping"
  | "packs"
  | "games record"
  | "sportsbook record"
  | null;

interface HistoryPanelProps {
  historySubTab: HistorySubTab;
  onSubTabChange: (tab: HistorySubTab) => void;
  onTotals: (deposit: number, withdraw: number) => void;
}

const HistoryPanel: React.FC<HistoryPanelProps> = ({
  historySubTab,
  onSubTabChange,
  onTotals,
}) => {
  const [tab, setTab] = useState("balance");
  const handleTabChange = (next: any) => {
    setTab(next);
    onSubTabChange?.(next);
  };
  return (
    <div className="space-y-4">
      <div className="flex flex-wrap gap-2 mt-4 2xl:gap-4">
        <button
          onClick={() => handleTabChange("balance")}
          className={`px-4 md:px-12 2xl:px-16 py-2 md:py-3 font-extrabold transition-all text-xs uppercase 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            tab === "balance"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-60"
          }`}
        >
          Balance
        </button>

        <button
          onClick={() => handleTabChange("shipping")}
          className={`px-4 md:px-12 2xl:px-16 py-2 md:py-3 font-extrabold transition-all text-xs uppercase 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            tab === "shipping"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
          }`}
        >
          shipping
        </button>

        <button
          onClick={() => handleTabChange("packs")}
          className={`px-4 md:px-12 2xl:px-16 py-2 md:py-3 font-extrabold transition-all text-xs uppercase 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            tab === "packs"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
          }`}
        >
          packs
        </button>
        <button
          onClick={() => handleTabChange("games record")}
          className={`px-4 md:px-12 2xl:px-16 py-2 md:py-3 font-extrabold transition-all text-xs uppercase 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            tab === "games record"
              ? " text-white !border-[var(--color-blue)]"
              : "text-[var(--color-slate)] hover:bg-gray-700/50 opacity-50"
          }`}
        >
          Games Record
        </button>

        <button
          onClick={() => handleTabChange("sportsbook record")}
          className={`px-4 md:px-12 2xl:px-16 py-2 md:py-3 font-extrabold transition-all text-xs uppercase 2xl:text-lg bg-[var(--color-naviBlue)] border-b-4 font-sofia border-transparent md:text-base ${
            tab === "sportsbook record"
              ? " text-white !border-[var(--color-blue)]"
              : "text-(--color-slate) hover:bg-gray-700/50 opacity-50"
          }`}
        >
          Sportsbook Record
        </button>
      </div>
      <div className=" space-y-6">
        {tab === "balance" && <Balance onTotals={onTotals} />}
        {tab === "shipping" && <Shipping />}
        {tab === "packs" && <Packs />}
        {tab === "games record" && <GamesRecord />}
        {tab === "sportsbook record" && <SportsbookRecord />}
      </div>
    </div>
  );
};

export default HistoryPanel;
