import type { MysteryPack } from "@/app/games/mystery-packs/Inner";
import type { PackUI } from "./types";

const VALUES_BY_TIER: Record<
  string,
  { avg: number; ranges: { label: string; percent: number }[] }
> = {
  BASIC: {
    avg: 25,
    ranges: [
      { label: "5-15", percent: 36 },
      { label: "15-30", percent: 34 },
      { label: "30-100", percent: 22 },
      { label: "100-250", percent: 6.5 },
      { label: "250-300", percent: 4.5 },
      { label: "300-450", percent: 0.5 },
    ],
  },
  "PRO BLUE": {
    avg: 60,
    ranges: [
      { label: "20-40", percent: 28 },
      { label: "40-80", percent: 35 },
      { label: "80-200", percent: 22 },
      { label: "200-400", percent: 10 },
      { label: "400-600", percent: 4.5 },
      { label: "600-900", percent: 0.5 },
    ],
  },
  GOLD: {
    avg: 120,
    ranges: [
      { label: "50-100", percent: 30 },
      { label: "100-200", percent: 35 },
      { label: "200-400", percent: 22 },
      { label: "400-700", percent: 9 },
      { label: "700-900", percent: 3.5 },
      { label: "900-1200", percent: 0.5 },
    ],
  },
  ELITE: {
    avg: 250,
    ranges: [
      { label: "100-200", percent: 25 },
      { label: "200-350", percent: 35 },
      { label: "350-600", percent: 23 },
      { label: "600-1000", percent: 12 },
      { label: "1000-1500", percent: 4.5 },
      { label: "1500-2500", percent: 0.5 },
    ],
  },
};

export function toPackUI(packs: MysteryPack[]): PackUI[] {
  return packs.map((p) => {
    const meta = VALUES_BY_TIER[p.tier] ?? VALUES_BY_TIER.BASIC;

    return {
      ...p,
      thumb: p.image, // reuse image as tab thumbnail
      averageValue: meta.avg,
      valueRanges: meta.ranges,
      chaseSlabs: Array.from({ length: 10 }).map((_, i) => ({
        id: `${p.id}-slab-${i}`,
        title:
          p.tier === "BASIC"
            ? "GLACEON EX"
            : p.tier === "PRO BLUE"
            ? "CHARIZARD V"
            : p.tier === "GOLD"
            ? "RAYQUAZA VMAX"
            : "GENGAR VMAX",
        subtitle: "SPECIAL • 10 GRADE",
        priceCoins: meta.avg * 18,
        image:
          p.tier === "BASIC"
            ? "/cards/glaceon.png"
            : p.tier === "PRO BLUE"
            ? "/cards/charizard.png"
            : p.tier === "GOLD"
            ? "/cards/rayquaza.png"
            : "/cards/gengar.png",
      })),
    };
  });
}
