import { AuthState } from "@/app/wallet/page";
import React from "react";
import { useSelector } from "react-redux";

interface SellConfirmModalProps {
  isOpen: boolean;
  onClose: () => void;
  totalValue: string; // e.g. "0.70"
  onConfirm: () => void;
  isSellCardsLoading: boolean;
}

const SellConfirmModal: React.FC<SellConfirmModalProps> = ({
  isOpen,
  onClose,
  totalValue,
  onConfirm,
  isSellCardsLoading,
}) => {
  const user = useSelector((state: { auth: AuthState }) => state.auth.user);
  const amount = Number(totalValue || 0).toFixed(2);

  if (!isOpen) return null;
  return (
    <div
      className="fixed inset-0 z-9999999 flex items-center justify-center bg-black/60"
      onClick={onClose}
    >
      <div
        onClick={(e) => e.stopPropagation()}
        className="bg-(--color-naviBlue) py-3 md:p-6 w-76 md:min-w-120 space-y-4 shadow-xl"
      >
        <p className="text-white flex items-center gap-1 text-center font-extrabold text-lg md:text-2xl mb-8 uppercase tracking-tight">
          {user?.activeMode === "coins" ? (
            <img src="/images/header/win.svg" alt="" className="h-4 w-4" />
          ) : (
            <img src="/images/header/star.svg" alt="" className="h-4 w-4" />
          )}
          <span>{amount} P-CREDS WILL BE ADDED TO YOUR ACCOUNT</span>
        </p>

        <div className="flex justify-center gap-4">
          <button
            onClick={onClose}
            className="px-4 py-1 cursor-pointer 2xl:py-2 text-sm border border-white text-white duration-300 hover:bg-gray-800"
          >
            CANCEL
          </button>
          <button
            onClick={onConfirm}
            className="px-4 py-1 cursor-pointer 2xl:py-2 text-sm border border-white text-white duration-300 hover:bg-gray-800"
          >
            {isSellCardsLoading ? "wait..." : "CONFIRM"}
          </button>
        </div>
      </div>
    </div>
  );
};

export default SellConfirmModal;
