// Footer.tsx
import Image from "next/image";
import Link from "next/link";

export default function Footer() {
  return (
    <footer className="bg-[#121924] text-white">
      <div className="mx-auto container px-4 py-10 md:py-12 lg:py-14">
        {/* Top: Social + 18+ badge */}
        <div className="flex flex-col gap-6 items-center justify-between md:flex-row md:items-center">
          {/* Social */}
          <div className="space-y-3">
            <p className="text-lg md:text-xl 2xl:text-2xl font-semibold font-sofia italic uppercase">
              Follow us on social media
            </p>
            <div className="flex items-center gap-3">
              {/* Social icon buttons */}
              <button className="flex h-10 w-10 items-center justify-center rounded-full bg-[#29313D] hover:bg-white/10 transition">
                {/* X / Twitter icon placeholder */}
                <img src="/images/footer/x.svg" alt="" />
              </button>
              <img src="/images/footer/insta.svg" alt="" />
              <button className="flex h-10 w-10 items-center justify-center rounded-full bg-[#29313D] hover:bg-white/10 transition">
                {/* YouTube icon placeholder */}
                <img src="/images/footer/youtube.svg" alt="" />
              </button>
            </div>
          </div>

          {/* 18+ badge */}
          <div className="mt-2 md:mt-0">
            <div className="flex items-center gap-3 md:justify-end">
              <div className="flex h-14 w-14 items-center justify-center rounded-full bg-white text-black">
                <span className="text-sm md:text-xl font-extrabold text-[#2A2F35] leading-none">
                  18+
                </span>
              </div>
              <p className="text-xs md:text-sm font-onest font-extrabold leading-tight tracking-wide uppercase text-gray-200">
                Gambling
                <br />
                Responsible
              </p>
            </div>
          </div>
        </div>

        {/* Divider */}
        <div className="mt-8 border-t-2 border-[#29313D]" />

        {/* Bottom: logo + link columns */}
        <div className="mt-8 flex flex-col gap-10 md:flex-row md:items-start md:justify-between">
          {/* Logo + copyright */}
          <div className="space-y-4">
            <div className="flex justify-center md:justify-start items-center gap-2">
              {/* Replace with your real logo image */}
              <Image
                src="/images/footer/footerLogo.svg"
                alt="TCGWIN"
                width={130}
                height={40}
                className="w-20 md:h-auto md:w-auto"
              />
            </div>
            <p className="text-xs md:text-xl text-center md:text-left tracking-widest pt-5 font-sofia font-extrabold font-sofia uppercase">
              © RW.SOFTWARE LLC (2025) All rights reserved.
            </p>
          </div>

          {/* Link groups */}
          <div className="grid grid-cols-2 gap-x-10 gap-y-6 sm:grid-cols-3 md:grid-cols-4">
            {/* Packs */}
            <div className="space-y-3">
              <h4 className="text-xs font-semibold font-sofia md:text-xl  text-[#DBFAFF] uppercase">
                Packs
              </h4>
              <ul className="space-y-1.5 text-sm font-onest">
                <li>
                  <Link href="/shop" className="hover:text-white">
                    Open packs
                  </Link>
                </li>
                <li>
                  <Link
                    href="/games/mystery-packs"
                    className="hover:text-white"
                  >
                    Slab Packs
                  </Link>
                </li>
                <li>
                  <Link href="/mystery-boxes" className="hover:text-white">
                    Mystery Boxes
                  </Link>
                </li>
                <li>
                  <Link href="trade" className="hover:text-white">
                    Trade Market
                  </Link>
                </li>
              </ul>
            </div>

            {/* Games */}
            <div className="space-y-3">
              <h4 className="text-xs md:text-xl font-semibold  text-[#DBFAFF] font-sofia  uppercase">
                Games
              </h4>
              <ul className="space-y-1.5 text-sm font-onest">
                <li>
                  <Link href="/sports" className="hover:text-white">
                    Sportsbook
                  </Link>
                </li>
                <li>
                  <Link href="/games/coinflip" className="hover:text-white">
                    Coinflip
                  </Link>
                </li>
                <li>
                  <Link href="/games/roll" className="hover:text-white">
                    Roll
                  </Link>
                </li>
                <li>
                  <Link href="/games/crash" className="hover:text-white">
                    Crash
                  </Link>
                </li>
              </ul>
            </div>

            {/* About */}
            <div className="space-y-3">
              <h4 className="text-xs md:text-xl font-semibold  text-[#DBFAFF] font-sofia  uppercase">
                About
              </h4>
              <ul className="space-y-1.5 text-sm font-onest">
                <li>
                  <Link href="/blogs" className="hover:text-white">
                    Blogs
                  </Link>
                </li>
                <li>
                  <Link href="/faqs" className="hover:text-white">
                    FAQs
                  </Link>
                </li>
                <li>
                  <Link href="/fairness" className="hover:text-white">
                    Fairness
                  </Link>
                </li>
              </ul>
            </div>

            {/* Legal */}
            <div className="space-y-3">
              <h4 className="text-xs md:text-xl font-semibold  text-[#DBFAFF] font-sofia  uppercase">
                Legal
              </h4>
              <ul className="space-y-1.5 text-sm font-onest">
                <li>
                  <Link href="/terms" className="hover:text-white">
                    Terms
                  </Link>
                </li>
                <li>
                  <Link href="/privacy" className="hover:text-white">
                    Privacy
                  </Link>
                </li>
                <li>
                  <Link href="/legal" className="hover:text-white">
                    Legal Policies
                  </Link>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </footer>
  );
}
