const rarityOdds = [
  { label: "Double Rare", value: "1/5" },
  { label: "Ultra Rare", value: "1/16" },
  { label: "Illustration Rare", value: "1/12" },
  { label: "Special Illustration Rare", value: "1/94" },
  { label: "Hyper Rare", value: "1/149" },
];

export function OddsList() {
  return (
    <div className=" 2xl:mt-4 w-full text-[11px] md:text-xs text-slate-200">
      {rarityOdds.map((item, idx) => (
        <div
          key={item.label}
          className={`flex items-center justify-between py-1.5 ${
            idx !== rarityOdds.length - 1 ? "border-b border-[#111827]" : ""
          }`}
        >
          <span className="font-semibold">{item.label}:</span>
          <span className="text-right text-slate-300">{item.value}</span>
        </div>
      ))}
    </div>
  );
}
