import Image from "next/image";
import { useState } from "react";
import { InternalButton } from "../ui/Button";
type CardDrop = {
  id: number;
  date: string;
  title: string;
  price: string;
  image: string; // image path
};

const MOCK_DROPS: CardDrop[] = [
  {
    id: 1,
    date: "7TH JULY 2025",
    title: "RAGING BOLT EX",
    price: "$121.90",
    image: "/images/profile/img2.svg",
  },
  {
    id: 2,
    date: "14TH JULY 2025",
    title: "FROSTED BLAZE",
    price: "$135.50",
    image: "/images/profile/img2.svg",
  },
  {
    id: 3,
    date: "21ST JULY 2025",
    title: "SHADOW STRIKE",
    price: "$149.75",
    image: "/images/profile/img2.svg",
  },
  {
    id: 4,
    date: "7TH JULY 2025",
    title: "RAGING BOLT EX",
    price: "$121.90",
    image: "/images/profile/img2.svg",
  },
  {
    id: 5,
    date: "14TH JULY 2025",
    title: "FROSTED BLAZE",
    price: "$135.50",
    image: "/images/profile/img2.svg",
  },
  {
    id: 6,
    date: "21ST JULY 2025",
    title: "SHADOW STRIKE",
    price: "$149.75",
    image: "/images/profile/img2.svg",
  },
  {
    id: 7,
    date: "21ST JULY 2025",
    title: "SHADOW STRIKE",
    price: "$149.75",
    image: "/images/profile/img2.svg",
  },
  // ...repeat / add more
];

type WinCard = {
  name: string;
  price: string;
  image: string;
};

type SessionListingProps = {
  myWinCards: WinCard[];
};

const SessionListing = ({ myWinCards }: SessionListingProps) => {
  const [detailCard, setDetailCard] = useState<CardDrop | null>(null);
  return (
    <div className="mt-3">
      <div className="h-[500px] border border-(--color-gray) container mx-auto">
        <div className="flex bg-(--color-gray) mb-5 items-center justify-between gap-3 p-4">
          <h1 className=" text-white font-onest font-onest font-bold text-sm md:text-xl 2xl:text-2xl ">
            Session Winning
          </h1>
          <InternalButton className="bg-transparent border-white border hover:!bg-[var(--color-naviBlue)]">
            ADD TO INVENTORY
          </InternalButton>
        </div>
        <div className="p-4">
          <section className="w-full">
            {/* horizontal scroll on small screens, grid on large */}
            <div className="nice-scrollbar -mx-4 flex gap-4 overflow-x-auto px-4 lg:mx-0 grid grid-cols-2 md::grid-cols-4 lg:grid-cols-7 lg:overflow-visible">
              {!myWinCards || myWinCards.length === 0 ? (
                <>
                  <h1 className="text-white">No cards</h1>
                </>
              ) : (
                <>
                  {myWinCards.map((card: any, index) => (
                    <article
                      onClick={(e) => {
                        e.stopPropagation();
                        setDetailCard(card);
                      }}
                      key={index}
                      className="flex cursor-pointer flex-col bg-[var(--color-naviBlue)] text-white shadow-lg shadow-black/40"
                    >
                      {/* Image */}
                      <div className="relative mx-3 mt-2 h-40 overflow-hidden ">
                        <Image
                          src={`/cards/${card.image}`}
                          alt={card.name}
                          fill
                          aria-hidden="true"
                          className="object-contain"
                        />
                      </div>

                      {/* Bottom: title + price */}
                      <div className=" bg-blur relative z-10 px-3 -mt-7 pb-4 pt-3 text-center">
                        <p className="text-xs md:text-sm font-sofia font-normal tracking-[0.16em] uppercase">
                          {card.name}
                        </p>
                        <p className="text-xs md:text-base font-extrabold font-sofia">
                          {card.price}
                        </p>
                      </div>
                    </article>
                  ))}
                </>
              )}
            </div>
          </section>
        </div>
      </div>
    </div>
  );
};

export default SessionListing;
