"use client";
import React from "react";

type Feature = {
  title: string;
  desc: string;
  image: string;
};

const features: Feature[] = [
  {
    title: "INVITE YOUR FRIENDS",
    desc: "Introduce Your Collectors to the Thrills of TCGWIN. Open Packs, Play games and collect together",
    image: "/images/affliate/arrow3.svg",
  },
  {
    title: "MAKE PROFIT ON DEPOSITS",
    desc: "Earn up to 5% Payback on Every Deposit from Your Referrals.",
    image: "/images/affliate/arrow2.svg",
  },
  {
    title: "CASHOUT",
    desc: "Earn up to 5% Payback on Every Deposit from Your Referrals.",
    image: "/images/affliate/arrow1.svg",
  },
];

export default function HowItWorks() {
  return (
    <div className="w-full my-5 mb-20 md:mt-10">
      <h1 className=" text-2xl md:text-3xl mb-5 font-extrabold">
        HOW IT WORKS
      </h1>
      <div className="grid gap-4 md:gap-6 md:grid-cols-3">
        {features.map((f) => (
          <div
            key={f.title}
            className="
              relative overflow-hidden 
              bg-[#161E2A]
              
              
              px-6 py-6 md:py-8 
            "
          >
            <div className=" flex items-center gap-4">
              <div className="shrink-0 absolute mt-2 -left-4">
                <img src={f.image} className="w-32 h-32" alt={f.title} />
              </div>

              <div className="max-w-[210px] ml-24 md:ml-28">
                <div className="text-white font-extrabold md:text-xl italic  text-sm uppercase">
                  {f.title}
                </div>
                <p className="mt-2 text-[#EFEFEF] text-xs font-onest  ">
                  {f.desc}
                </p>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
}
