import Link from "next/link";
import React from "react";

const ShopPacks = () => {
  return (
    <div className="bg-[#161E2A] mt-5 md:mt-10 overflow-hidden px-4 md:px-0 py-4 ">
      <div className=" container mx-auto p-5 mt-4 flex items-center flex-col md:flex-row gap-4 justify-between w-full">
        <div className="flex flex-col gap-3">
          <h1 className="font-sofia italic font-bold text-base md:text-2xl 2xl:text-2xl">
            VIRTUALLY OPEN PACKS,
          </h1>
          <h1 className="font-sofia italic font-bold text-base md:text-2xl -mt-4 2xl:text-2xl">
            GET REAL CARDS
          </h1>

          <Link
            href="/shop"
            className="bg-[#4D4CFE]  transistion-all duration-300 hover:bg-[var(--color-hoverBlue)] mt-5 font-onest font-semibold text-xs md:text-sm 2xl:text-base py-2 px-10 "
          >
            Shop Packs
          </Link>
        </div>
        <div className="flex relative  -mb-24 items-center">
          <div className="absolute bottom-17 left-1/2 -translate-x-1/2 w-[150px] md:w-[470px] h-[200px] md:h-[250px] bg-[var(--color-blue)] blur-3xl rounded-full opacity-50"></div>
          <img
            src="/images/roll/left.webp"
            className="w-24 md:w-[163px] object-contain relative z-10 -mr-5 h-[236px]"
            alt=""
          />
          <img
            src="/images/roll/center.webp"
            className="w-24 md:w-[163px] object-contain relative z-20 h-[298px]"
            alt=""
          />

          <img
            src="/images/roll/right.webp"
            className="w-24 md:w-[163px] object-contain -ml-5 relative z-10 h-[236px]"
            alt=""
          />
        </div>
      </div>
    </div>
  );
};

export default ShopPacks;
