import Link from "next/link";
import React from "react";

const MysteryBoxes = () => {
  return (
    <section className="border-[#29313D] bg-img1 py-10 bg-img relative overflow-hidden">
      <div className=" container mx-auto w-full">
        <div className="max-w-195 mx-auto px-3  flex items-center flex-col md:flex-row gap-4 justify-between ">
          <div className="flex flex-col relative z-10 gap-3">
            <h1 className="font-sofia italic font-extrabold text-base md:text-2xl 2xl:text-2xl">
              OPEN TCG MYSTERY BOXES
            </h1>
            <p className="max-w-[350px]  text-[#54657E] md:leading-7 font-medium text-sm md:text-lg 2xl:text-2xl">
              Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
              eiusmod tempor incididunt ut labore et.
            </p>
            <Link
              href="/mystery-boxes"
              className="bg-[#4D4CFE] w-fit transistion-all duration-300 hover:bg-(--color-hoverBlue) mt-2 font-onest text-xs md:text-sm 2xl:text-base py-2 px-3 md:px-5 2xl:px-10 "
            >
              See Boxes
            </Link>
          </div>
          <div className="">
            <img
              src="/images/mystery-bozes/blue.svg"
              className="blur-xs absolute rotate-32 z-0 -top-3 -right-18"
              alt=""
            />
            <img
              src="/images/mystery-bozes/yellow.svg"
              className="blur-[2px] absolute w-52 -rotate-10 -bottom-3 -left-16"
              alt=""
            />
            <div className="bg-black/30 backdrop-blur-xl p-4">
              <h1 className="mb-3 md:mb-5 justify-center font-extrabold italic text-[#DBFAFF] uppercase text-xs md:text-base flex items-center gap-2">
                <img src="/images/home/1.svg" className="w-2" alt="" />
                <span>tcgwin games</span>
              </h1>
              <img
                src="/images/mystery-bozes/lightBlue.svg"
                alt=""
                className="w-38 md:w-52 2xl:w-76.5 2xl:h-58.25"
              />
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default MysteryBoxes;
