"use client";

import Image from "next/image";
import { useRouter } from "next/navigation";
import { RollSlider } from "../Home2/RollSlider";
import "./../../components/home/style.css";

type Game = {
  id: string;
  label: string;
  href: string; // ✅ add this
  bgSrc: string;
  img1: string;
  img2: string;
  img3: string;
  fgClassName?: string;
};

const games: Game[] = [
  {
    id: "packs",
    label: "PACKS",
    href: "/shop",
    bgSrc: "/images/home/bg.svg",
    img1: "/images/home/crashImg.svg",
    img2: "/images/home/v.svg",
    img3: "/images/home/crash.svg",
    fgClassName: "",
  },
  {
    id: "boxes",
    label: "BOXES",
    href: "/mystery-boxes",
    bgSrc: "/images/home/bg.svg",
    img1: "/images/home/slide1.svg",
    img2: "/images/home/slide1.svg",
    img3: "/images/home/slide1.svg",
    fgClassName: "",
  },
  {
    id: "mystery",
    label: "MYSTERY SLABS",
    href: "/games/mystery-packs",
    bgSrc: "/images/home/bg.svg",
    img1: "/images/home/slide1.svg",
    img2: "/images/home/slide1.svg",
    img3: "/images/home/slide1.svg",
    fgClassName: "",
  },
];

export default function PacksModes({ closePacks }: any) {
  const router = useRouter();
  return (
    <section className="w-full mt-2.5 py-10">
      <div className="">
        <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
          {games.map((game) => (
            <button
              key={game.id}
              onClick={() => {
                closePacks();
                router.push(game.href);
              }}
              className="group cursor-pointer flex flex-col items-center text-center focus:outline-none"
            >
              {/* CARD */}
              <div className="relative w-full h-[180px] overflow-hidden rounded-md shadow-lg shadow-black/50 transition-all duration-300 ">
                {/* BG (same) */}
                <Image
                  src={game.bgSrc}
                  alt=""
                  fill
                  className={`${
                    game.id === "crash" && "group-hover:scale-115"
                  } object-cover transition-transform duration-500 ease-out`}
                  priority
                />

                {/* optional dark overlay */}
                <div className="" />

                {game.id === "packs" && (
                  <div className="flex mt-5 hover:scale-115 transition-all duration-300 justify-center items-center ">
                    <img
                      src="/images/home/left.png"
                      className="w-14 md:w-[65px] blur-[2px] object-contain mt-6 relative z-50 -mr-3 "
                      alt=""
                    />
                    <div className="absolute bottom-5 left-1/2 -translate-x-1/2 w-20 md:w-222 hidden lg:block h-22.5 bg-(--color-blue) blur-3xl rounded-full opacity-70" />

                    <div className="relative  flex h-full">
                      {/* <img
                        src="/images/home/m3.svg"
                        className="w-16 md:w-[63px] object-contain -rotate-12  z-50 absolute -left-12 group-hover:translate-x-0 duration-500 transition-all translate-x-16 -mt-2 md:mt-0 -translate-y-[1px] top-5  "
                        alt=""
                      /> */}

                      <img
                        src="/images/home/m1.svg"
                        className="w-20 md:w-[95px] mt-6 object-contain relative z-99 "
                        alt=""
                      />

                      {/* <img
                        src="/images/home/m2.svg"
                        className="w-16 md:w-[63px] -mt-2 md:mt-0 group-hover:translate-x-0 duration-500 transition-all -translate-x-12  group-hover:rotate-14 object-contain -ml-3  z-60 absolute -right-12 top-5 "
                        alt=""
                      /> */}
                    </div>

                    <img
                      src="/images/home/right.png"
                      className="w-14 md:w-[65px] blur-[2px] object-contain -ml-3 mt-6 relative z-50"
                      alt=""
                    />
                  </div>
                )}

                {game.id === "boxes" && (
                  <>
                    {/* BADGE (TOP MOST) */}
                    <div className="absolute top-3 left-1/2 -translate-x-1/2 z-40 mt-7">
                      <div
                        className="
        transition-all duration-500
        group-hover:scale-115
        
      "
                      >
                        <div className="absolute bottom-5 left-1/2 -translate-x-1/2 w-52 hidden lg:block h-32.5 bg-(--color-blue) blur-3xl rounded-full opacity-70" />
                        <div className="flex items-center relative z-40 w-56 flex-col text-white  ">
                          <img
                            src="/images/mystery-bozes/blue.svg"
                            className=""
                            alt=""
                          />
                        </div>
                      </div>
                    </div>
                    <div className="absolute top-0 left-10 -translate-x-1/2 z-30 mt-7">
                      <div
                        className="
        transition-all duration-500 rotate-20
        group-hover:scale-115
        // group-hover:-translate-y-4
        // group-hover:translate-x-4
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 ">
                          <img
                            src="/images/home/c3.svg"
                            className="-mt-5"
                            alt=""
                          />
                        </div>
                      </div>
                    </div>

                    <div className="absolute top-0 -right-5  z-30 mt-7">
                      <div
                        className="
        transition-all duration-500 -rotate-40
        group-hover:scale-115
        group-hover:-translate-y-8
        group-hover:-translate-x-32
      "
                      >
                        <div className="flex items-center flex-col text-white p-3 ">
                          <img
                            src="/images/home/c1.svg"
                            className="-mt-5"
                            alt=""
                          />
                        </div>
                      </div>
                    </div>
                  </>
                )}
                {game.id === "mystery" && (
                  <>
                    <div className="flex mt-5 justify-center items-center ">
                      <img
                        src="/images/roll/left.webp"
                        className="w-14 md:w-[53px] blur-[2px] object-contain -rotate-14  relative z-50 -mr-3 "
                        alt=""
                      />

                      <div className="relative flex  h-full">
                        <img
                          src="/images/home/m3.svg"
                          className="w-16 md:w-[63px] object-contain -rotate-12  z-50 absolute -left-12 group-hover:translate-x-0 duration-500 transition-all translate-x-16 -mt-2 md:mt-0 -translate-y-[1px] top-5  "
                          alt=""
                        />

                        <img
                          src="/images/home/m1.svg"
                          className="w-20 md:w-[85px] object-contain relative z-99 "
                          alt=""
                        />

                        <img
                          src="/images/home/m2.svg"
                          className="w-16 md:w-[63px] -mt-2 md:mt-0 group-hover:translate-x-0 duration-500 transition-all -translate-x-12  group-hover:rotate-14 object-contain -ml-3  z-60 absolute -right-12 top-5 "
                          alt=""
                        />
                      </div>

                      <img
                        src="/images/roll/right.webp"
                        className="w-14 md:w-[53px] blur-[2px] rotate-12 object-contain -ml-3 relative z-50"
                        alt=""
                      />
                    </div>
                  </>
                )}
              </div>

              <span className="mt-3 font-sofia md:text-xl 2xl:text-2xl font-extrabold text-sm text-white">
                {game.label}
              </span>
            </button>
          ))}
        </div>
      </div>
    </section>
  );
}
