import {
  B2BINPAY_ACCESS_TOKEN,
  B2BINPAY_BASE_URL,
  B2BINPAY_WALLET_ID,
  BASE_URL,
  LOCAL_APP_URL,
  
} from "@/constants";

export async function POST(req: Request) {
  const { amount } = await req.json();

  const res = await fetch(`${B2BINPAY_BASE_URL}/deposit/`, {
    method: "POST",
    headers: {
      Authorization: `Bearer ${B2BINPAY_ACCESS_TOKEN}`,
      "Content-Type": "application/vnd.api+json",
    },
    body: JSON.stringify({
      data: {
        type: "deposit",
        attributes: {
          label: "User Deposit",
          tracking_id: `dep_${Date.now()}`,
          callback_url: `${BASE_URL}/api/b2binpay/callback`,
          target_amount_requested: String(amount),
          payment_page_redirect_url: `${LOCAL_APP_URL}/deposit/success`,
        },
        relationships: {
          wallet: {
            data: {
              type: "wallet",
              id: B2BINPAY_WALLET_ID,
            },
          },
        },
      },
    }),
  });

  const json = await res.json();
  if (!res.ok) {
    return new Response(JSON.stringify(json), { status: 400 });
  }

  return new Response(
    JSON.stringify({
      paymentPage: json.data.attributes.payment_page,
    }),
    { status: 200 }
  );
}
